function [Gini_1, Gini_2, Gini_3] = MeGini_test_myself(q, Nf, Psim, Psif, wS_m, wS_f, wU_m, wU_f )

qSS_m=q(1);
qSS_f=q(2);
qUS_m=q(3);
qUS_f=q(4);
qSU_m=q(5);
qSU_f=q(6);
qUU_m=q(7);
qUU_f=q(8);

thetaSm=(1-Nf)*Psim+Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*Psim*(1-Psif)*max(qSU_m,qSU_f);
thetaUm=(1-Nf)*(1-Psim)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);
thetaSf=Nf*Psim*Psif*max(qSS_m,qSS_f)+Nf*(1-Psim)*Psif*max(qUS_m,qUS_f);
thetaUf=Nf*Psim*(1-Psif)*max(qSU_m,qSU_f)+Nf*(1-Psim)*(1-Psif)*max(qUU_m,qUU_f);

piss=Nf*Psim*Psif*(1-max(qSS_m,qSS_f))+ min(thetaSm,thetaSf);
pisu=Nf*Psim*(1-Psif)*(1-max(qSU_m,qSU_f));
pius=Nf*(1-Psim)*Psif*(1-max(qUS_m,qUS_f));
piuu=Nf*(1-Psim)*(1-Psif)*(1-max(qUU_m,qUU_f))+min(thetaUm,thetaUf);
pis=max(thetaSm-thetaSf,0);
piu=max(thetaUm-thetaUf,0);

I_SS=piss*(wS_m+wS_f);
I_SU=pisu*(wS_m+wU_f);
I_US=pius*(wU_m+wS_f);
I_UU=piuu*(wU_m+wU_f);
I_S=pis*wS_m; 
I_U=piu*wU_m; 

I_denominator_1=I_SS+I_SU+I_US+I_UU+I_S+I_U;
    
chi_SS_1=(I_SS)/I_denominator_1;
chi_SU_1=(I_SU)/I_denominator_1;
chi_US_1=(I_US)/I_denominator_1;
chi_UU_1=(I_UU)/I_denominator_1;
chi_S_1=(I_S)/I_denominator_1;
chi_U_1=(I_U)/I_denominator_1;

areaA=(piu*chi_U_1)/2;
areaB=(pis*(chi_U_1+(chi_U_1+chi_S_1)))/2;
areaC=(piuu*((chi_U_1+chi_S_1)+(chi_U_1+chi_S_1+chi_UU_1)))/2;
areaD=(pius*((chi_U_1+chi_S_1+chi_UU_1)+(chi_U_1+chi_S_1+chi_UU_1+chi_US_1)))/2;
areaE=(pisu*((chi_U_1+chi_S_1+chi_UU_1+chi_US_1)+(chi_U_1+chi_S_1+chi_UU_1+chi_US_1+chi_SU_1)))/2;
areaF=(piss*((chi_U_1+chi_S_1+chi_UU_1+chi_US_1+chi_SU_1)+(chi_U_1+chi_S_1+chi_UU_1+chi_US_1+chi_SU_1+chi_SS_1)))/2;
 
area_all=areaA+areaB+areaC+areaD+areaE+areaF;

Gini_1=1-2*area_all;

%% Exclude singles

I_denominator_2=I_SS+I_SU+I_US+I_UU;

chi_SS_2=(I_SS)/I_denominator_2;
chi_SU_2=(I_SU)/I_denominator_2;
chi_US_2=(I_US)/I_denominator_2;
chi_UU_2=(I_UU)/I_denominator_2;

lambda_UU = piuu/(piuu+pius+pisu+piss);
lambda_US = pius/(piuu+pius+pisu+piss);
lambda_SU = pisu/(piuu+pius+pisu+piss);
lambda_SS = piss/(piuu+pius+pisu+piss);

C=(lambda_UU*(chi_UU_2))/2;
D=(lambda_US*(chi_UU_2+(chi_UU_2+chi_US_2)))/2;
E=(lambda_SU*((chi_UU_2+chi_US_2)+(chi_UU_2+chi_US_2+chi_SU_2)))/2;
F=(lambda_SS*((chi_UU_2+chi_US_2+chi_SU_2)+(chi_UU_2+chi_US_2+chi_SU_2+chi_SS_2)))/2;

area_all_2 = C + D + E + F;

Gini_2=1-2*area_all_2;

%% Gini per capita income inequality
% 10 types of agent

I_denominator_3=I_SS+I_SU+I_US+I_UU+I_S+I_U;

chi_SS_3=(I_SS/2)/I_denominator_3;
chi_SU_3=(I_SU/2)/I_denominator_3;
chi_US_3=(I_US/2)/I_denominator_3;
chi_UU_3=(I_UU/2)/I_denominator_3;
chi_S_3=(I_S)/I_denominator_3;
chi_U_3=(I_U)/I_denominator_3;

lambda_UU_3 = piuu/(2*piuu+2*pius+2*pisu+2*piss+pis+piu);
lambda_US_3 = pius/(2*piuu+2*pius+2*pisu+2*piss+pis+piu);
lambda_SU_3 = pisu/(2*piuu+2*pius+2*pisu+2*piss+pis+piu);
lambda_SS_3 = piss/(2*piuu+2*pius+2*pisu+2*piss+pis+piu);
lambda_S_3 = pis/(2*piuu+2*pius+2*pisu+2*piss+pis+piu);
lambda_U_3 = piu/(2*piuu+2*pius+2*pisu+2*piss+pis+piu);

areaA_3=(lambda_UU_3*chi_UU_3)/2;
areaB_3=(lambda_UU_3*(chi_UU_3+(chi_UU_3+chi_UU_3)))/2;
areaC_3=(lambda_U_3*((chi_UU_3+chi_UU_3)+(chi_UU_3+chi_UU_3+chi_U_3)))/2;
areaD_3=(lambda_US_3*((chi_UU_3+chi_UU_3+chi_U_3)+(chi_UU_3+chi_UU_3+chi_U_3+chi_US_3)))/2;
areaE_3=(lambda_US_3*((chi_UU_3+chi_UU_3+chi_U_3+chi_US_3)+(chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3)))/2;
areaF_3=(lambda_SU_3*((chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3)+(chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3)))/2;
areaG_3=(lambda_SU_3*((chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3)+(chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3+chi_SU_3)))/2;
areaH_3=(lambda_SS_3*((chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3+chi_SU_3)+(chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3+chi_SU_3+chi_SS_3)))/2;
areaJ_3=(lambda_SS_3*((chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3+chi_SU_3+chi_SS_3)+(chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3+chi_SU_3+chi_SS_3+chi_SS_3)))/2;
areaK_3=(lambda_S_3*((chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3+chi_SU_3+chi_SS_3+chi_SS_3)+(chi_UU_3+chi_UU_3+chi_U_3+chi_US_3+chi_US_3+chi_SU_3+chi_SU_3+chi_SS_3+chi_SS_3+chi_S_3)))/2;

area_all_3 = areaA_3 + areaB_3 + areaC_3 + areaD_3 + areaE_3 + areaF_3 + areaG_3 + areaH_3 + areaJ_3 + areaK_3;

Gini_3=1-2*area_all_3;


end

